%% Initialisierung

% clear all
close all
% clc

clear team_daten

spiel = teams_einlesen;


%% Fenster

fenster_handle = figure ( ...
    'Position', [100 100 1000 600], ...
    'Menu', 'none', ...
    'NumberTitle', 'off', ...
    'Name', 'Intro', ...
    'color', 'white' ...
    );


%% Teamname

n_name = length (spiel.rot.name);

name_text = repmat (' ', 1, 2*n_name - 1);

name_text(1 : 2 : 2*n_name) = spiel.rot.name;

uicontrol ( ...
    'Style', 'text', ...
    'String', name_text, ...
    'FontUnits', 'normalized ', ...
    'FontSize', 0.8, ...
    'BackgroundColor', 'white', ...
    'ForegroundColor', [0.4 0.4 0.4], ...
    'Units', 'normalized', ...
    'Position', [0 520/600 1 50/600] ...
    )


%% Mitarbeiter

n_mitarbeiter = size (spiel.rot.mitarbeiter, 2);

for i_mitarbeiter = 1 : n_mitarbeiter
    
    i_zeile = fix ((i_mitarbeiter - 1)/4);

    i_spalte = mod (i_mitarbeiter - 1, 4);
    
    mitarbeiter_handle = axes ( ...
        'Position', [ ...
        i_spalte*250/1000 + 25/1000 ...
        (1 - i_zeile)*250/600 + 50/600 ...
        200/1000 ...
        200/600] ...
        );
    
    bild = imread ( ...
        ['teams/rot/media/', ...
        spiel.rot.mitarbeiter(i_mitarbeiter).name, ...
        '.jpg']);
    
    image (bild);
    
    % Muss man leider noch mal machen, 
    % da image die Achsenskalierung wieder anschaltet.
    set (mitarbeiter_handle, 'Visible', 'off') 
    
    uicontrol ( ...
        'Style', 'text', ...
        'String', spiel.rot.mitarbeiter(i_mitarbeiter).name, ...
        'FontUnits', 'normalized ', ...
        'FontSize', 0.8, ...
        'BackgroundColor', 'white', ...
        'Units', 'normalized', ...
        'Position', [ ...
        i_spalte*250/1000 + 25/1000 ...
        (1 - i_zeile)*250/600 + 25/600 ...
        200/1000 ...
        20/600] ...
        )
    
    uicontrol ( ...
        'Style', 'text', ...
        'String', spiel.rot.mitarbeiter(i_mitarbeiter).aufgabe, ...
        'FontUnits', 'normalized ', ...
        'FontSize', 0.8, ...
        'BackgroundColor', 'white', ...
        'ForegroundColor', [0.4 0.4 0.4], ...
        'Units', 'normalized', ...
        'Position', [ ...
        i_spalte*250/1000 + 25/1000 ...
        (1 - i_zeile)*250/600 ...
        200/1000 ...
        20/600] ...
        )
   
end


%% Sound (auf 10 Sekunden begrenzen)

[daten, rate] = audioread ('teams/rot/media/intro.wav');

n_max = min (size (daten, 1), 10*rate);

sound (daten(1 : n_max, :), rate);
