function spiel = spielfeld_darstellen (spiel)


%% Spielfeld

spiel.fenster_handle = figure ( ...
    'Position', [600 200 750 450], ...
    'Position', [-1100 700 1000 600], ...
    'Position', [200 100 2000 1200], ...
    'Position', [-1600 600 1500 900], ...
    'Position', [600 200 1000 600], ... % Normal
    'Menu', 'none', ...
    'NumberTitle', 'off', ...
    'Name', 'Spaceballs', ...
    'Color', 'white' ...
    );


%% Logo

spiel.rot.logo_handle = axes ( ...
    'Position', [0/1000 400/600 200/1000 200/600] ...
    );

image (spiel.rot.logo, ...
    'Parent', spiel.rot.logo_handle ...
    )

set (spiel.rot.logo_handle, ...
    'Visible', 'off' ...
    );

spiel.blau.logo_handle = axes ( ...
    'Position', [800/1000 400/600 200/1000 200/600] ...
    );

image (spiel.blau.logo, ...
    'Parent', spiel.blau.logo_handle ...
    )

set (spiel.blau.logo_handle, ...
    'Visible', 'off' ...
    );


%% Rahmen

spiel.spielfeld_handle = axes ( ...
    'ButtonDownFcn', ...
    'set (spiel.fenster_handle, ''UserData'', false)', ...
    'box', 'on', ...
    'XTick', [], ...
    'YTick', [], ...
    'Position', [200/1000 0/600 600/1000 600/600], ...
    'XLim', [0 1], ...
    'YLim', [0 1] ...
    );


%% Zeitbalken

spiel.zeit_handle = rectangle ( ...
    'Parent', spiel.spielfeld_handle, ...
    'EdgeColor', 'none', ...
    'FaceColor', spiel.farbe.grau ...
    );


%% Slider

spiel.spur_slider_handle = uicontrol ( ...
    'Style', 'slider', ...
    'Min', 0, ...
    'Max', spiel.n_t, ...
    'Value', spiel.spur_anfangswert, ...
    'Units', 'normalized', ...
    'Position', [10/1000 10/600 180/1000 20/600] ...
    );

spiel.spur_text_handle = uicontrol ( ...
    'Style', 'text', ...
    'String', 'Spur', ...
    'Units', 'normalized', ...
    'BackgroundColor', 'white', ...
    'FontUnits', 'normalized ', ...
    'Fontsize', 0.5, ...
    'HorizontalAlignment', 'left', ...
    'Position', [10/1000 30/600 180/1000 30/600] ...
    );

spiel.zeitlupe_slider_handle = uicontrol ( ...
    'Style', 'slider', ...
    'Min', 0, ...
    'Max', 1, ...
    'Value', spiel.zeitlupe_anfangswert, ...
    'Units', 'normalized', ...
    'Position', [810/1000 10/600 180/1000 20/600] ...
    );

spiel.zeitlupe_text_handle = uicontrol ( ...
    'Style', 'text', ...
    'String', 'Zeitlupe', ...
    'Units', 'normalized', ...
    'BackgroundColor', 'white', ...
    'FontUnits', 'normalized ', ...
    'Fontsize', 0.5, ...
    'HorizontalAlignment', 'left', ...
    'Position', [810/1000 30/600 180/1000 30/600] ...
    );


%% Checkboxes

spiel.ges_checkbox_handle = uicontrol ( ...
    'Style', 'checkbox', ...
    'Value', spiel.ges_checkbox_anfangswert, ...
    'Units', 'normalized', ...
    'BackgroundColor', 'white', ...
    'String', 'Geschwindigkeit', ...
    'FontUnits', 'normalized ', ...
    'Fontsize', 0.5, ...
    'Position', [10/1000 70/600 180/1000 30/600] ...
    );

spiel.bes_checkbox_handle = uicontrol ( ...
    'Style', 'checkbox', ...
    'Value', spiel.bes_checkbox_anfangswert, ...
    'Units', 'normalized', ...
    'BackgroundColor', 'white', ...
    'String', 'Beschleunigung', ...
    'FontUnits', 'normalized ', ...
    'Fontsize', 0.5, ...
    'Position', [10/1000 100/600 180/1000 30/600] ...
    );

spiel.zeitraffer_checkbox_handle = uicontrol ( ...
    'Style', 'checkbox', ...
    'Value', spiel.zeitraffer_checkbox_anfangswert, ...
    'Units', 'normalized', ...
    'BackgroundColor', 'white', ...
    'String', 'Zeitraffer', ...
    'FontUnits', 'normalized ', ...
    'Fontsize', 0.5, ...
    'Position', [810/1000 70/600 180/1000 30/600] ...
    );


%% Texte

uicontrol ( ...
    'Style', 'text', ...
    'String', spiel.rot.name, ...
    'Units', 'normalized', ...
    'BackgroundColor', 'white', ...
    'FontUnits', 'normalized ', ...
    'Fontsize', 0.25, ...
    'Position', [10/1000 300/600 180/1000 100/600] ...
    );

spiel.rot.getankt_handle = uicontrol ( ...
    'Style', 'text', ...
    'Units', 'normalized', ...
    'BackgroundColor', 'white', ...
    'FontUnits', 'normalized ', ...
    'Fontsize', 0.5, ...
    'Position', [10/1000 270/600 180/1000 30/600] ...
    );

spiel.rot.punkte_handle = uicontrol ( ...
    'Style', 'text', ...
    'Units', 'normalized', ...
    'BackgroundColor', 'white', ...
    'FontUnits', 'normalized ', ...
    'Fontsize', 0.5, ...
    'Position', [10/1000 240/600 180/1000 30/600] ...
    );

spiel.rot.ereignis_handle = uicontrol ( ...
    'Style', 'text', ...
    'Units', 'normalized', ...
    'BackgroundColor', 'white', ...
    'FontUnits', 'normalized ', ...
    'Fontsize', 0.5, ...
    'Position', [10/1000 210/600 180/1000 30/600] ...
    );

uicontrol ( ...
    'Style', 'text', ...
    'String', spiel.blau.name, ...
    'Units', 'normalized', ...
    'BackgroundColor', 'white', ...
    'FontUnits', 'normalized ', ...
    'Fontsize', 0.25, ...
    'Position', [810/1000 300/600 180/1000 100/600] ...
    );

spiel.blau.getankt_handle = uicontrol ( ...
    'Style', 'text', ...
    'Units', 'normalized', ...
    'BackgroundColor', 'white', ...
    'FontUnits', 'normalized ', ...
    'Fontsize', 0.5, ...
    'Position', [810/1000 270/600 180/1000 30/600] ...
    );

spiel.blau.punkte_handle = uicontrol ( ...
    'Style', 'text', ...
    'Units', 'normalized', ...
    'BackgroundColor', 'white', ...
    'FontUnits', 'normalized ', ...
    'Fontsize', 0.5, ...
    'Position', [810/1000 240/600 180/1000 30/600] ...
    );

spiel.blau.ereignis_handle = uicontrol ( ...
    'Style', 'text', ...
    'Units', 'normalized', ...
    'BackgroundColor', 'white', ...
    'FontUnits', 'normalized ', ...
    'Fontsize', 0.5, ...
    'Position', [810/1000 210/600 180/1000 30/600] ...
    );


%% Mine

for i_mine = 1 : spiel.n_mine
    
    spiel.mine(i_mine).graphics_handle = rectangle ( ...
        'Parent', spiel.spielfeld_handle, ...
        'Position', [...
        spiel.mine(i_mine).pos - spiel.mine(i_mine).radius, ...
        2*spiel.mine(i_mine).radius, ...
        2*spiel.mine(i_mine).radius], ...
        'Curvature', [1 1], ...
        'FaceColor', spiel.farbe.grau, ...
        'EdgeColor', 'none' ...
        );
    
end


%% Tanke

for i_tanke = 1 : spiel.n_tanke
    
    spiel.tanke(i_tanke).graphics_handle = rectangle ( ...
        'Parent', spiel.spielfeld_handle, ...
        'Position', [...
        spiel.tanke(i_tanke).pos - spiel.tanke(i_tanke).radius, ...
        2*spiel.tanke(i_tanke).radius, ...
        2*spiel.tanke(i_tanke).radius], ...
        'Curvature', [1 1], ...
        'FaceColor', spiel.farbe.gruen, ...
        'EdgeColor', 'none' ...
        );
    
end


%% Spur

spiel.rot.spur_handle = line ( ...
    'Parent', spiel.spielfeld_handle, ...
    'LineStyle', '--' ...
    );

spiel.blau.spur_handle = line ( ...
    'Parent', spiel.spielfeld_handle, ...
    'LineStyle', '--' ...
    );


%% Spaceballs

spiel.rot.spaceball_handle = rectangle ( ...
    'Parent', spiel.spielfeld_handle, ...
    'Curvature', [1 1], ...
    'EdgeColor', 'none' ...
    );

spiel.blau.spaceball_handle = rectangle ( ...
    'Parent', spiel.spielfeld_handle, ...
    'Curvature', [1 1], ...
    'EdgeColor', 'none' ...
    );


%% Beschleunigung

spiel.rot.bes_handle = patch ( ...
    'Parent', spiel.spielfeld_handle, ...
    'EdgeColor', 'none' ...
    );

spiel.blau.bes_handle = patch ( ...
    'Parent', spiel.spielfeld_handle, ...
    'EdgeColor', 'none' ...
    );


%% Geschwindigkeit

spiel.rot.ges_handle = line ( ...
    'Parent', spiel.spielfeld_handle, ...
    'LineWidth', 1 ...
    );

spiel.blau.ges_handle = line ( ...
    'Parent', spiel.spielfeld_handle, ...
    'LineWidth', 1 ...
    );