function second_order_2(block)
% Level-2 MATLAB file S-Function for second order system.

%   Copyright 1990-2009 The MathWorks, Inc.

setup(block);

%endfunction

function setup(block)

%% Register number of input and output ports
block.NumInputPorts  = 1;
block.NumOutputPorts = 1;

%% Setup functional port properties to dynamically inherited.
block.SetPreCompInpPortInfoToDynamic;
block.SetPreCompOutPortInfoToDynamic;

block.InputPort(1).Dimensions        = 1;
block.InputPort(1).DirectFeedthrough = false;

block.OutputPort(1).Dimensions       = 1;

%% Set block sample time to continuous
block.SampleTimes = [0 0];

%% Setup Dwork
block.NumContStates = 2;

%% Set the block simStateCompliance to default (i.e., same as a built-in block)
block.SimStateCompliance = 'DefaultSimState';

%% Register methods
block.RegBlockMethod('Outputs',                 @Output);
block.RegBlockMethod('Derivatives',             @Derivative);

%endfunction

function Output(block)

x = block.ContStates.Data;

y = x(1);

block.OutputPort(1).Data = y;

%endfunction

function Derivative(block)

u =  block.InputPort(1).Data;

x = block.ContStates.Data;

d(1) =              x(2);
d(2) = - 2*x(1) - 2*x(2) + 4*u;

block.Derivatives.Data = d;

%endfunction

